import net.BurtonRadons.dig.main;
import net.BurtonRadons.dig.platform.scintilla;
import std.file;

class FileMenu : Menu
{
    Program program;

    this (Program program)
    {
        super ((Control) null);
        this.program = program;
        add ("&Open", &Open);
        add ("&Close", &Close);
    }

    void Open ()
    {
        char [] [] result;

        with (new FileSelector (false))
        {
            multiSelect = false;
            addFilter ("D", "*.d");
            addFilter ("All Files", "*");
            result = run ();
        }

        if (result.length)
            program.load (result [0]);
    }

    void Close ()
    {
        Frame.quit ();
    }
}

class MyMenuBar : MenuBar
{
    Program program;

    this (Program program)
    {
        super ();
        this.program = program;
        popup ("&File", new FileMenu (program));
    }
}

class Program : Frame
{
    ScintillaText text;

    this ()
    {
        super (new MyMenuBar (this));

        caption ("Scintilla Example");
        border (0, 0);

        with (text = new ScintillaText (this))
        {
            grid (0, 0);
            pad (0, 0);
            sticky ("<>^v");
            suggestWidthAndHeight (400, 300);
            SetLexer (LexCpp);
            SetKeyWords(0, "this super assert null true false cast new delete "
                    "throw module template instance void byte ubyte short ushort int "
                    "uint long ulong float double extended bit char wchar imaginary "
                    "complex delegate if else while for do switch case default break "
                    "continue synchronized return goto try catch finally with asm struct "
                    "class interface union enum import static final const typedef alias "
                    "override abstract volatile debug deprecated in out inout auto align "
                    "extern private protected public export body invariant unittest version "
            );

            StyleSetFore(1, 0x007F00);
            StyleSetFore(2, 0x007F00);
            StyleSetFore(3, 0x007F00);
            StyleSetFore(4, 0x007F7F);
            StyleSetFore(5, 0xFF0000);
            StyleSetFore(6, 0x7F007F);
            StyleSetFore(7, 0x7F007F);
            StyleSetFore(10, 0x7F7F00);
        }

        load ("scintilla.d");
    }

    void load (char [] filename)
    {
        try
        {
            char [] b = cast (char [])std.file.read (filename);
            b ~= 0;
            
            text.SetText (cast (char []) b);
        }
        catch (FileException e)
            text.SetText ("Couldn't read " ~ filename ~ ".  doh.");

        caption (filename ~ " - Scintilla Example");
    }
}
 
void main ()
{
    (new Program).showModal();
}
